my $shelp = <<'EOHELP';
Says something to the people in the room with you.
EOHELP

MObject->Fields (
  can_speak => {default => 0},
);

MObject->Commands (
#---------------------------------------------------------------------------------------------------
  say    => {code => sub {$_[0]->speak(text => $_[1], range => 4,   label => 'say', help => $shelp)}},
# shout  => {code => sub {$_[0]->speak(text => $_[1], range => 30,   label => 'shout')}},
# holler => {code => sub {$_[0]->speak(text => $_[1], range => 1000, label => 'holler')}},
#---------------------------------------------------------------------------------------------------
  emote => {code => sub {
    my ($self, $args) = @_;
    $args or $self->send("Emote what?"), return;
    $args =~ s/([^!?.])$/$1./;
    my $npar = ($args =~ /\b(hit|you|stab|slash|pound|leave|arrive|vanish|moves?|(dis)?appear)\b/);
    my $t = ($npar?"(":'') . $self->name . " $args" . ($npar?")":'');
    $self->nact($self->dg_escape($t));
  }, help => <<'EOH'},
This command allows you to describe actions that you perform. It has no effect on the world, and if your phrase contains a word which is considered to be an attempt to fool someone into thinking it's an actual game message, your message will be enclosed in parentheses.

Examples:
> emote smiles
Marn smiles.
> emote punches you
(Marn punches you.)
> emote looks around worriedly. You wonder why.
Marn looks around worriedly. You wonder why.
EOH
#---------------------------------------------------------------------------------------------------
';' => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $args) = @_;
    foreach (values %MConnection::Connections) {
      my $po = $_->object;
      $po->send("&:c;;" . $self->name . ": $args&:n;") if ($po and $po->priv_watcher);
    }
  },
},
#---------------------------------------------------------------------------------------------------
echo => {
  code => sub {
    my ($self, $args) = @_;
    my $msg = $self->dg_escape($args);
    my $from = $self->priv_runner ? '' : '(' . $self->name . ')';
    my $line = $msg . (' ' x ($self->connection->scr_width - (length($msg) + length $from))) . $from;
    $self->nact($line);
  },
}, 
#---------------------------------------------------------------------------------------------------
);

MObject->CommandAliases (
  say => [qw(')],
  emote => [qw(:)],
);

MObject->Methods (

speak => sub {
  my ($self, %params) = @_;
  
  $self->can_speak or die "CFAIL:You don't seem to have anything to speak with.";
  
  # FIXME: reenable this code when drunkenness is back
  
  my $is_drunk = 0;
  if (0 and $is_drunk = $self->drunk > 5) {local $_ = $params{text}; for my $i (1..$self->drunk - 5) {
    &{[
      sub {s/s/th/i},
      sub {s/le/la/i},
      sub {s/\B([a-df-ln-z])\1\B/$1$1-$1$1/i},
      sub {s/je/she/i},
      sub {s/go/guh/i},
      sub {s/ou/aw/i},
      sub {s/o/er/i},
      sub {s/u/ho/i},
      sub {s/e/ay/i},
      sub {s/e/ra/i},
      sub {s/\B[a-z]\B//i},
      sub {s/\s([\w])\B/ $1-$1-$1/i},
      sub {s/(\w{8})/"$1 *hic*"/ei},
      sub {s/ic/ic-hic/i},
    ]->[rand 14]};
  }; $params{text} = $_;}

  my $drt = $is_drunk > 5 ? ' drunkenly' : '';
  $self->nact("<self.aud?<self> $params{label}<self.is!s>$drt \"" . $self->dg_escape($params{text}) . '">');
  1;
},  

);
